/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.testing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

public class Scenario
implements PortableObject {
    private static final long serialVersionUID = 510L;
    private int maxRuleFirings = 100000;
    private List<FactData> globals = new ArrayList<FactData>();
    private List<Fixture> fixtures = new ArrayList<Fixture>();
    private Date lastRunResult;
    private List<String> rules = new ArrayList<String>();
    private boolean inclusive = false;

    public boolean wasSuccessful() {
        for (Fixture fixture : this.fixtures) {
            if (!(fixture instanceof Expectation) || ((Expectation)fixture).wasSuccessful()) continue;
            return false;
        }
        return true;
    }

    public void insertBetween(Fixture fixtureBeforeTheNewOne, Fixture newFixture) {
        int start;
        boolean inserted = false;
        for (int j = start = fixtureBeforeTheNewOne == null ? 0 : this.fixtures.indexOf(fixtureBeforeTheNewOne) + 1; j < this.fixtures.size(); ++j) {
            if (!(this.fixtures.get(j) instanceof ExecutionTrace)) continue;
            this.getFixtures().add(j, newFixture);
            return;
        }
        if (!inserted) {
            this.fixtures.add(newFixture);
        }
    }

    public void removeFixture(Fixture f) {
        this.fixtures.remove(f);
        this.globals.remove(f);
    }

    public void removeExecutionTrace(ExecutionTrace executionTrace) {
        this.removeExpected(executionTrace);
        this.removeGiven(executionTrace);
    }

    private void removeExpected(ExecutionTrace executionTrace) {
        boolean remove = false;
        Iterator<Fixture> iterator = this.getFixtures().iterator();
        while (iterator.hasNext()) {
            Fixture fixture = iterator.next();
            if (fixture.equals(executionTrace)) {
                remove = true;
                continue;
            }
            if (remove && fixture instanceof ExecutionTrace) break;
            if (!remove || !(fixture instanceof Expectation)) continue;
            iterator.remove();
            this.globals.remove(fixture);
        }
    }

    private void removeGiven(ExecutionTrace executionTrace) {
        Collections.reverse(this.getFixtures());
        boolean remove = false;
        Iterator<Fixture> iterator = this.getFixtures().iterator();
        while (iterator.hasNext()) {
            Fixture fixture = iterator.next();
            if (fixture.equals(executionTrace)) {
                remove = true;
            } else if (remove && fixture instanceof ExecutionTrace) break;
            if (!remove || fixture instanceof Expectation) continue;
            iterator.remove();
            this.globals.remove(fixture);
        }
        Collections.reverse(this.getFixtures());
    }

    public Map<String, FactData> getFactTypes() {
        HashMap<String, FactData> factTypesByName = new HashMap<String, FactData>();
        for (Fixture fixture : this.fixtures) {
            if (!(fixture instanceof FactData)) continue;
            FactData factData = (FactData)fixture;
            factTypesByName.put(factData.getName(), factData);
        }
        for (FactData factData : this.globals) {
            factTypesByName.put(factData.getName(), factData);
        }
        return factTypesByName;
    }

    public Map<String, String> getVariableTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Fixture fixture : this.fixtures) {
            if (!(fixture instanceof FactData)) continue;
            FactData factData = (FactData)fixture;
            map.put(factData.getName(), factData.getType());
        }
        for (FactData factData : this.globals) {
            map.put(factData.getName(), factData.getType());
        }
        return map;
    }

    public Map<String, List<FactData>> getFactTypesToFactData() {
        HashMap<String, List<FactData>> map = new HashMap<String, List<FactData>>();
        for (Fixture fixture : this.fixtures) {
            if (!(fixture instanceof FactData)) continue;
            FactData factData = (FactData)fixture;
            ArrayList<FactData> fd = (ArrayList<FactData>)map.get(factData.getType());
            if (fd == null) {
                fd = new ArrayList<FactData>();
                map.put(factData.getType(), fd);
            }
            fd.add(factData);
        }
        for (FactData factData : this.globals) {
            ArrayList<FactData> fd = (ArrayList<FactData>)map.get(factData.getType());
            if (fd == null) {
                fd = new ArrayList<FactData>();
                map.put(factData.getType(), fd);
            }
            fd.add(factData);
        }
        return map;
    }

    public List<String> getFactNamesInScope(ExecutionTrace executionTrace, boolean includeGlobals) {
        if (executionTrace == null) {
            return Collections.emptyList();
        }
        ArrayList<String> factDataNames = new ArrayList<String>();
        int p = this.getFixtures().indexOf(executionTrace);
        for (int i = 0; i < p; ++i) {
            Fixture fixture = this.getFixtures().get(i);
            if (fixture instanceof FactData) {
                FactData factData = (FactData)fixture;
                factDataNames.add(factData.getName());
                continue;
            }
            if (!(fixture instanceof RetractFact)) continue;
            RetractFact retractFact = (RetractFact)fixture;
            factDataNames.remove(retractFact.getName());
        }
        if (includeGlobals) {
            for (FactData factData : this.getGlobals()) {
                factDataNames.add(factData.getName());
            }
        }
        return factDataNames;
    }

    public boolean isFactNameReserved(String factName) {
        if (this.isFactNameUsedInGlobals(factName)) {
            return true;
        }
        return this.isFactNameUsedInFactDataFixtures(factName);
    }

    protected boolean isFactNameUsedInFactDataFixtures(String factName) {
        for (Fixture fixture : this.fixtures) {
            FactData factData;
            if (!(fixture instanceof FactData) || !(factData = (FactData)fixture).getName().equals(factName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFactNameUsedInGlobals(String factName) {
        for (FactData factData : this.globals) {
            if (!factData.getName().equals(factName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFactDataReferenced(FactData factData) {
        int start = this.fixtures.indexOf(factData) + 1;
        String factName = factData.getName();
        for (Fixture fixture : this.fixtures.subList(start, this.fixtures.size())) {
            if (!this.isFactNameUsedInThisFixture(fixture, factName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFactNameUsedInThisFixture(Fixture fixture, String factName) {
        if (fixture instanceof FactData) {
            return ((FactData)fixture).getName().equals(factName);
        }
        if (fixture instanceof VerifyFact) {
            return ((VerifyFact)fixture).getName().equals(factName);
        }
        if (fixture instanceof RetractFact) {
            return ((RetractFact)fixture).getName().equals(factName);
        }
        return false;
    }

    public int[] countFailuresTotal() {
        int total = 0;
        int failures = 0;
        for (Fixture fixture : this.fixtures) {
            if (fixture instanceof VerifyRuleFired) {
                ++total;
                VerifyRuleFired verifyRuleFired = (VerifyRuleFired)fixture;
                if (!this.ruleFailedToFire(verifyRuleFired)) continue;
                ++failures;
                continue;
            }
            if (!(fixture instanceof VerifyFact)) continue;
            VerifyFact verifyFact = (VerifyFact)fixture;
            for (VerifyField verifyField : verifyFact.getFieldValues()) {
                if (this.fieldExpectationFailed(verifyField)) {
                    ++failures;
                }
                ++total;
            }
        }
        return new int[]{failures, total};
    }

    protected boolean fieldExpectationFailed(VerifyField verifyField) {
        return verifyField.getSuccessResult() != null && verifyField.getSuccessResult() == false;
    }

    protected boolean ruleFailedToFire(VerifyRuleFired verifyRuleFired) {
        return verifyRuleFired.getSuccessResult() != null && verifyRuleFired.getSuccessResult() == false;
    }

    public List<Fixture> getFixtures() {
        return this.fixtures;
    }

    public int getMaxRuleFirings() {
        return this.maxRuleFirings;
    }

    public List<FactData> getGlobals() {
        return this.globals;
    }

    public void setLastRunResult(Date lastRunResult) {
        this.lastRunResult = lastRunResult;
    }

    public Date getLastRunResult() {
        return this.lastRunResult;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }
}

